/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.rooms.ItemAllocation;

public class MoveAndPlaceItemGoal
extends Goal {
    private final MessageDispatcher messageDispatcher;
    private final TiledMap areaMap;
    private final ItemAllocation stockpileAllocation;

    public MoveAndPlaceItemGoal(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap, ItemAllocation stockpileAllocation) {
        super(parentEntity);
        this.messageDispatcher = messageDispatcher;
        this.areaMap = areaMap;
        this.stockpileAllocation = stockpileAllocation;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        try {
            Goal currentChildGoal = (Goal)this.childGoals.peek();
            if (currentChildGoal != null) {
                currentChildGoal.update(deltaTimeSeconds);
                if (currentChildGoal.isComplete()) {
                    this.childGoals.pop();
                }
            }
        }
        catch (GoalException e) {
            if (this.stockpileAllocation != null) {
                this.messageDispatcher.dispatchMessage(701, this.stockpileAllocation);
            }
            throw e;
        }
    }

    public ItemAllocation getStockpileAllocation() {
        return this.stockpileAllocation;
    }

    @Override
    public boolean isComplete() {
        return this.childGoals.isEmpty();
    }
}

